/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.client.guidebook.Guide;
import appeng.client.guidebook.compiler.MdAstNodeAdapter;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.indices.PageIndex;
import appeng.items.tools.powered.MatterCannonItem;
import appeng.libs.mdast.MdAstVisitor;
import appeng.libs.mdast.model.MdAstHeading;
import appeng.libs.mdast.model.MdAstNode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.mattercannon.MatterCannonAmmo;
import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipe;
import appeng.siteexport.model.ExportedPageJson;
import appeng.siteexport.model.FluidInfoJson;
import appeng.siteexport.model.ItemInfoJson;
import appeng.siteexport.model.NavigationNodeJson;
import appeng.siteexport.model.P2PTypeInfo;
import appeng.siteexport.model.SiteExportJson;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1874;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3955;
import net.minecraft.class_3975;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteExportWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SiteExportWriter.class);
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeHierarchyAdapter(MdAstNode.class, (Object)new MdAstNodeAdapter()).registerTypeAdapter(class_2960.class, (Object)new WriteOnlyTypeAdapter<class_2960>(){

        public void write(JsonWriter out, class_2960 value) throws IOException {
            out.value(value.toString());
        }
    }).registerTypeAdapter(class_1856.class, (Object)new WriteOnlyTypeAdapter<class_1856>(){

        public void write(JsonWriter out, class_1856 value) throws IOException {
            out.beginArray();
            for (class_1799 item : value.method_8105()) {
                class_2960 itemId = class_7923.field_41178.method_10221((Object)item.method_7909());
                out.value(itemId.toString());
            }
            out.endArray();
        }
    }).registerTypeHierarchyAdapter(class_1792.class, (Object)new WriteOnlyTypeAdapter<class_1792>(){

        public void write(JsonWriter out, class_1792 value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(class_7923.field_41178.method_10221((Object)value).toString());
            }
        }
    }).registerTypeHierarchyAdapter(class_3611.class, (Object)new WriteOnlyTypeAdapter<class_3611>(){

        public void write(JsonWriter out, class_3611 value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(class_7923.field_41173.method_10221((Object)value).toString());
            }
        }
    }).registerTypeAdapter(class_1799.class, (Object)new WriteOnlyTypeAdapter<class_1799>(){

        public void write(JsonWriter out, class_1799 value) throws IOException {
            if (value == null || value.method_7960()) {
                out.nullValue();
            } else {
                out.value(class_7923.field_41178.method_10221((Object)value.method_7909()).toString());
            }
        }
    }).registerTypeAdapter(Boolean.class, (Object)new WriteOnlyTypeAdapter<Boolean>(){

        public void write(JsonWriter out, Boolean value) throws IOException {
            out.value(value.booleanValue());
        }
    }).create();
    private final SiteExportJson siteExport = new SiteExportJson();

    public SiteExportWriter(Guide guide) {
        this.siteExport.defaultNamespace = guide.getDefaultNamespace();
        this.siteExport.navigationRootNodes = guide.getNavigationTree().getRootNodes().stream().map(NavigationNodeJson::of).toList();
    }

    public void addItem(String id, class_1799 stack, String iconPath) {
        ItemInfoJson itemInfo = new ItemInfoJson();
        itemInfo.id = id;
        itemInfo.icon = iconPath;
        itemInfo.displayName = stack.method_7964().getString();
        itemInfo.rarity = stack.method_7932().name().toLowerCase(Locale.ROOT);
        this.siteExport.items.put(itemInfo.id, itemInfo);
    }

    public void addFluid(String id, FluidVariant fluid, String iconPath) {
        FluidInfoJson fluidInfo = new FluidInfoJson();
        fluidInfo.id = id;
        fluidInfo.icon = iconPath;
        fluidInfo.displayName = ((class_2561)FluidVariantRendering.getTooltip((FluidVariant)fluid).get(0)).getString();
        this.siteExport.fluids.put(fluidInfo.id, fluidInfo);
    }

    public void addRecipe(class_3955 recipe) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            fields.put("shapeless", false);
            fields.put("width", shapedRecipe.method_8150());
            fields.put("height", shapedRecipe.method_8158());
        } else {
            fields.put("shapeless", true);
        }
        class_1799 resultItem = recipe.method_8110(null);
        fields.put("resultItem", resultItem);
        fields.put("resultCount", resultItem.method_7947());
        fields.put("ingredients", recipe.method_8117());
        this.addRecipe((class_1860<?>)recipe, (Map<String, Object>)fields);
    }

    public void addRecipe(InscriberRecipe recipe) {
        class_1799 resultItem = recipe.getResultItem();
        this.addRecipe(recipe, Map.of("top", recipe.getTopOptional(), "middle", recipe.getMiddleInput(), "bottom", recipe.getBottomOptional(), "resultItem", resultItem.method_7909(), "resultCount", resultItem.method_7947(), "consumesTopAndBottom", recipe.getProcessType() == InscriberProcessType.PRESS));
    }

    public void addRecipe(class_1874 recipe) {
        this.addRecipe((class_1860<?>)recipe, Map.of("resultItem", recipe.method_8110(null), "ingredient", recipe.method_8117().get(0)));
    }

    public void addRecipe(TransformRecipe recipe) {
        HashMap<String, Object> circumstanceJson = new HashMap<String, Object>();
        TransformCircumstance circumstance = recipe.circumstance;
        if (circumstance.isExplosion()) {
            circumstanceJson.put("type", "explosion");
        } else if (circumstance.isFluid()) {
            circumstanceJson.put("type", "fluid");
            if (recipe.circumstance.isFluidTag((class_6862<class_3611>)class_3486.field_15517)) {
                circumstanceJson.put("fluids", List.of(class_3612.field_15910));
            } else {
                circumstanceJson.put("fluids", circumstance.getFluidsForRendering());
            }
        } else {
            throw new IllegalStateException("Unknown circumstance: " + circumstance.toJson());
        }
        this.addRecipe(recipe, Map.of("resultItem", recipe.method_8110(null), "ingredients", recipe.method_8117(), "circumstance", circumstanceJson));
    }

    public void addRecipe(EntropyRecipe recipe) {
        this.addRecipe(recipe, Map.of("mode", recipe.getMode().name().toLowerCase(Locale.ROOT)));
    }

    public void addRecipe(MatterCannonAmmo recipe) {
        this.addRecipe(recipe, Map.of("ammo", recipe.getAmmo(), "damage", MatterCannonItem.getDamageFromPenetration(recipe.getWeight())));
    }

    public void addRecipe(ChargerRecipe recipe) {
        this.addRecipe(recipe, Map.of("resultItem", recipe.getResultItem(), "ingredient", recipe.getIngredient()));
    }

    public void addRecipe(class_8060 recipe) {
        this.addRecipe((class_1860<?>)recipe, (Map<String, Object>)Map.of("resultItem", recipe.method_8110(null), "base", recipe.field_42031, "addition", recipe.field_42032, "template", recipe.field_42030));
    }

    public void addRecipe(class_8062 recipe) {
        this.addRecipe((class_1860<?>)recipe, (Map<String, Object>)Map.of("base", recipe.field_42036, "addition", recipe.field_42037, "template", recipe.field_42035));
    }

    public void addRecipe(class_3975 recipe) {
        this.addRecipe((class_1860<?>)recipe, Map.of("resultItem", recipe.method_8110(null), "ingredient", recipe.method_8117().get(0)));
    }

    public void addRecipe(class_1860<?> recipe, Map<String, Object> element) {
        JsonElement jsonElement = GSON.toJsonTree(element);
        class_2960 id = recipe.method_8114();
        String type = class_7923.field_41188.method_10221((Object)recipe.method_17716()).toString();
        jsonElement.getAsJsonObject().addProperty("type", type);
        if (this.siteExport.recipes.put(id.toString(), jsonElement) != null) {
            throw new RuntimeException("Duplicate recipe id " + id);
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(bout);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            GSON.toJson((Object)this.siteExport, (Appendable)writer);
        }
        return bout.toByteArray();
    }

    public void addP2PType(P2PTypeInfo typeInfo) {
        this.siteExport.p2pTunnelTypes.add(typeInfo);
    }

    public void addColoredVersion(class_1792 baseItem, class_1767 color, class_1792 coloredItem) {
        String baseItemId = class_7923.field_41178.method_10221((Object)baseItem).toString();
        String coloredItemId = class_7923.field_41178.method_10221((Object)coloredItem).toString();
        Map coloredVersions = this.siteExport.coloredVersions.computeIfAbsent(baseItemId, key -> new HashMap());
        coloredVersions.put(color, coloredItemId);
    }

    public void addPage(ParsedGuidePage page) {
        ExportedPageJson exportedPage = new ExportedPageJson();
        if (page.getFrontmatter().navigationEntry() != null) {
            exportedPage.title = page.getFrontmatter().navigationEntry().title();
        } else {
            exportedPage.title = this.extractPageTitle(page);
            if (exportedPage.title.isEmpty()) {
                LOG.warn("Unable to determine page title for {}: {}", (Object)page.getId(), (Object)exportedPage.title);
            }
        }
        exportedPage.astRoot = page.getAstRoot();
        exportedPage.frontmatter.putAll(page.getFrontmatter().additionalProperties());
        this.siteExport.pages.put(page.getId(), exportedPage);
    }

    private String extractPageTitle(ParsedGuidePage page) {
        final StringBuilder pageTitle = new StringBuilder();
        page.getAstRoot().visit(new MdAstVisitor(){

            @Override
            public MdAstVisitor.Result beforeNode(MdAstNode node) {
                if (node instanceof MdAstHeading) {
                    MdAstHeading heading = (MdAstHeading)node;
                    if (heading.depth == 1) {
                        pageTitle.append(heading.toText());
                    }
                    return MdAstVisitor.Result.STOP;
                }
                return MdAstVisitor.Result.CONTINUE;
            }
        });
        return pageTitle.toString();
    }

    public String addItem(class_1799 stack) {
        MessageDigest digest;
        String itemId = stack.method_7909().method_40131().method_40237().method_29177().toString().replace(':', '-');
        if (stack.method_7969() == null) {
            return itemId;
        }
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try (DataOutputStream out = new DataOutputStream(new DigestOutputStream(OutputStream.nullOutputStream(), digest));){
            class_2507.method_10628((class_2487)stack.method_7969(), (DataOutput)out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return itemId + "-" + HexFormat.of().formatHex(digest.digest());
    }

    public void addIndex(Guide guide, Class<? extends PageIndex> indexClass) {
        try (JsonTreeWriter jsonWriter = new JsonTreeWriter();){
            PageIndex index = guide.getIndex(indexClass);
            index.export((JsonWriter)jsonWriter);
            this.siteExport.pageIndices.put(indexClass.getName(), jsonWriter.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static abstract class WriteOnlyTypeAdapter<T>
    extends TypeAdapter<T> {
        private WriteOnlyTypeAdapter() {
        }

        public T read(JsonReader in) {
            throw new UnsupportedOperationException();
        }
    }
}

